package PerlWordCount::WordCount;
#-----------------------------------------------------------------------

# Utworzenie obiektu 'PerlWordCount::WordCount', 
# moliwe jest take ustawienie waciwoci 'Text'

=for interface
     [interface: pure]
     static WordCount WordCount();
     static WordCount WordCount(str text);
=cut

sub new {
    my ($package,$text) = @_;
    my $self = bless {} => $package;
    $self->Text($text);
    return $self;
}
#-----------------------------------------------------------------------

# Uzyskanie lub ustawienie waciwoci 'Text' oraz aktualizacja licznikw sw

=for interface
     str Text;
=cut

sub Text {
    my ($self,$text) = @_;
    return $self->{Text} unless defined $text;

    $self->{Text} = $text;
    $self->{Count} = {};

    # Konwersja wszystkich znakw nie bdcych literami do pojedynczej spacji
    $text =~ tr/a-zA-Z/ /cs;

    # Podzia tekstu w miejscu wystpienia spacji i policzenie sw
    ++$self->{Count}->{$_} foreach split(' ', lc $text);
}
#-----------------------------------------------------------------------

# 'Count' zwraca liczb wystpie lub zgasza wyjtek

=for interface
     int Count();
     int Count(str word);
=cut

sub Count {
    my ($self,$word) = @_;

    # Metoda 'Count' bez argumentw zwraca liczb poszczeglnych sw
    return int keys %{$self->{Count}} unless defined $word;

    # Zgoszenie wyjtku, jeli $word nie wystpuje w 'Text'
    die "Nie odnaleziono sowa '$word'" unless defined $self->{Count}->{$word};

    # Zwrcenie liczby wystpie
    return $self->{Count}->{$word};
}
#-----------------------------------------------------------------------

# 'Words' zwraca posortowan alfabetycznie *list* wszystkich sw w 'Text'

=for interface
     wantarray! str[] Words();
=cut

sub Words {
    my ($self) = @_;
    return sort keys %{$self->{Count}};
}

1;
